const mysql = require("mysql2/promise");

(async () => {
  try {
    const conn = await mysql.createConnection({
      host: "localhost",
      user: "root",
      password: "",
      database: "tuc",
    });

    // Show all tables
    const [tables] = await conn.execute("SHOW TABLES");
    console.log("\n📊 ALL TABLES IN DATABASE:");
    console.log("================================");
    tables.forEach((t, i) => {
      const tableName = Object.values(t)[0];
      console.log(`  ${i + 1}. ${tableName}`);
    });

    console.log(`\n📈 Total tables: ${tables.length}`);

    await conn.end();
  } catch (error) {
    console.error("❌ Error:", error.message);
    process.exit(1);
  }
})();
