import "dotenv/config";
import app from "./app";
import http from "http";
import { initializeDatabase } from "./db";

const PORT = process.env.PORT || 3000;

const server = http.createServer(app);

async function startServer() {
  try {
    await initializeDatabase();
    console.log("Database initialized successfully");

    server.listen(PORT as number, "192.168.8.103", () => {
      console.log(`Server is running on port ${PORT} 192.168.1.20`);
    });
  } catch (error) {
    console.error("Failed to start server:", error);
    process.exit(1);
  }
}

startServer();
