import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const userManagement = mysqlTable("user_management", {
  id: int("id").primaryKey().autoincrement(),
  name: varchar("name", { length: 255 }).notNull(),
  phoneNumber: varchar("phoneNumber", { length: 15 }).notNull(),
  role: mysqlEnum("role", ["Admin", "Shopkeeper", "Tailor", "Master"]).default(
    "Admin"
  ),
  hasShopAccess: boolean("hasShopAccess").default(false),
  hasUserAccess: boolean("hasUserAccess").default(false),
  hasOrderAccess: boolean("hasOrderAccess").default(false),
  hasSizeDefinitionAccess: boolean("hasSizeDefinitionAccess").default(false),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type UserManagement = typeof userManagement.$inferSelect;
export type InsertUserManagement = typeof userManagement.$inferInsert;
