import {
  mysqlTable,
  int,
  varchar,
  datetime,
  boolean,
  json,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const users = mysqlTable("users", {
  id: int("id").primaryKey().autoincrement(),
  name: varchar("name", { length: 100 }).notNull(),
  email: varchar("email", { length: 100 }).notNull().unique(),
  phoneNumber: varchar("phoneNumber", { length: 20 }).notNull().default(""),
  password: varchar("password", { length: 255 }).notNull(),
  role: mysqlEnum("role", ["Admin", "Shopkeeper", "Tailor", "Master"])
    .notNull()
    .default("Admin"),
  modules: json("modules").default(sql`'[]'`), // JSON array of modules
  isDeleted: boolean("isDeleted").notNull().default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type User = typeof users.$inferSelect;
export type InsertUser = typeof users.$inferInsert;
