import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  foreignKey,
  json,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { sessions } from "./session";

export const students = mysqlTable(
  "students",
  {
    id: int("id").primaryKey().autoincrement(),
    sessionId: int("sessionId").notNull(),
    name: varchar("name", { length: 255 }).notNull(),
    gender: varchar("gender", { length: 50 }).notNull(),
    sizeNumber: varchar("sizeNumber", { length: 50 }).notNull(),
    upperWear: json("upperWear").notNull(),
    lowerWear: json("lowerWear").notNull(),
    headcover: json("headcover"),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    sessionIdFk: foreignKey({
      columns: [table.sessionId],
      foreignColumns: [sessions.id],
    }),
  })
);

export type Student = typeof students.$inferSelect;
export type InsertStudent = typeof students.$inferInsert;
