import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  json,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const sizeDefinitions = mysqlTable("size_definitions", {
  id: int("id").primaryKey().autoincrement(),
  sizeNumber: varchar("sizeNumber", { length: 50 }).notNull(),
  gender: varchar("gender", { length: 50 }).notNull(),
  upperWear: json("upperWear").notNull(),
  lowerWear: json("lowerWear").notNull(),
  headCover: json("headCover"),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type SizeDefinition = typeof sizeDefinitions.$inferSelect;
export type InsertSizeDefinition = typeof sizeDefinitions.$inferInsert;
