import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  foreignKey,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { shops } from "./shop";

export const shopProducts = mysqlTable(
  "shop_products",
  {
    id: int("id").primaryKey().autoincrement(),
    shopId: int("shopId").notNull(),
    shopName: varchar("shopName", { length: 100 }).notNull(),
    shopProductName: varchar("shopProductName", { length: 100 }).notNull(),
    shopProductUnit: varchar("shopProductUnit", { length: 50 }).notNull(),
    remainingStock: int("remainingStock").notNull().default(0),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    shopIdFk: foreignKey({
      columns: [table.shopId],
      foreignColumns: [shops.id],
    }),
  })
);

export type ShopProduct = typeof shopProducts.$inferSelect;
export type InsertShopProduct = typeof shopProducts.$inferInsert;
