import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  json,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const shops = mysqlTable("shops", {
  id: int("id").primaryKey().autoincrement(),
  name: varchar("name", { length: 100 }).notNull(),
  location: varchar("location", { length: 255 }).notNull(),
  number: varchar("number", { length: 15 }).notNull(),
  shopkeeperIds: json("shopkeeperIds").default(sql`'[]'`), // JSON array of user IDs
  shopkeeperNames: json("shopkeeperNames").default(sql`'[]'`), // JSON array of user names
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type Shop = typeof shops.$inferSelect;
export type InsertShop = typeof shops.$inferInsert;
