import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  foreignKey,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { classes } from "./class";

export const sessions = mysqlTable(
  "sessions",
  {
    id: int("id").primaryKey().autoincrement(),
    name: varchar("name", { length: 255 }).notNull(),
    classId: int("classId").notNull(),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    classIdFk: foreignKey({
      columns: [table.classId],
      foreignColumns: [classes.id],
    }),
  })
);

export type Session = typeof sessions.$inferSelect;
export type InsertSession = typeof sessions.$inferInsert;
