import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const schools = mysqlTable("schools", {
  id: int("id").primaryKey().autoincrement(),
  logo: varchar("logo", { length: 255 }).notNull(),
  name: varchar("name", { length: 255 }).notNull(),
  address: varchar("address", { length: 255 }).notNull(),
  principalName: varchar("principalName", { length: 100 }),
  principalContact: varchar("principalContact", { length: 15 }),
  receptionistName: varchar("receptionistName", { length: 100 }),
  receptionistContact: varchar("receptionistContact", { length: 15 }),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type School = typeof schools.$inferSelect;
export type InsertSchool = typeof schools.$inferInsert;
