import {
  mysqlTable,
  int,
  varchar,
  decimal,
  boolean,
  datetime,
  foreignKey,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { products } from "./product";

export const purchases = mysqlTable(
  "purchases",
  {
    id: int("id").primaryKey().autoincrement(),
    productId: int("productId").notNull(),
    productName: varchar("productName", { length: 255 }).notNull(),
    productUnit: varchar("productUnit", { length: 100 }).notNull(),
    quantity: int("quantity").notNull(),
    totalPrice: decimal("totalPrice", { precision: 10, scale: 2 }).notNull(),
    perUnitPrice: decimal("perUnitPrice", {
      precision: 10,
      scale: 2,
    }).notNull(),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    productIdFk: foreignKey({
      columns: [table.productId],
      foreignColumns: [products.id],
    }),
  })
);

export type Purchase = typeof purchases.$inferSelect;
export type InsertPurchase = typeof purchases.$inferInsert;
