import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const products = mysqlTable("products", {
  id: int("id").primaryKey().autoincrement(),
  productName: varchar("productName", { length: 255 }).notNull(),
  productUnit: varchar("productUnit", { length: 100 }).notNull(),
  remainingStock: int("remainingStock").notNull().default(0),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type Product = typeof products.$inferSelect;
export type InsertProduct = typeof products.$inferInsert;
