import {
  mysqlTable,
  int,
  varchar,
  datetime,
  foreignKey,
  json,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { orders } from "./order";

export const orderDetails = mysqlTable(
  "order_details",
  {
    id: int("id").primaryKey().autoincrement(),
    orderId: int("orderId").notNull(),
    studentName: varchar("studentName", { length: 255 }).notNull(),
    sizeNumber: varchar("sizeNumber", { length: 50 }).notNull(),
    gender: mysqlEnum("gender", ["male", "female"]).notNull(),
    orderOf: mysqlEnum("orderOf", ["upperWear", "lowerWear", "both"]).notNull(),
    upperWear: json("upperWear"),
    lowerWear: json("lowerWear"),
    headCover: json("headCover"),
    addons: json("addons"), // New addons field as JSON array
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    orderIdFk: foreignKey({
      columns: [table.orderId],
      foreignColumns: [orders.id],
    }),
  })
);

export type OrderDetail = typeof orderDetails.$inferSelect;
export type InsertOrderDetail = typeof orderDetails.$inferInsert;
