import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  foreignKey,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { schools } from "./school";
import { users } from "./user";

export const orders = mysqlTable(
  "orders",
  {
    id: int("id").primaryKey().autoincrement(),
    schoolId: int("schoolId").notNull(),
    masterId: int("masterId").notNull(), // Foreign key to users table (Master role)
    name: varchar("name", { length: 255 }).notNull(),
    address: varchar("address", { length: 255 }).notNull(),
    phoneNumber: varchar("phoneNumber", { length: 15 }).notNull(),
    totalPrice: varchar("totalPrice", { length: 255 }).notNull(),
    type: mysqlEnum("type", ["Bulk Order", "Custom Order"]).notNull(),
    status: mysqlEnum("status", ["Pending", "Tailor", "Stitching", "Kajbutton", "Done"])
      .notNull()
      .default("Pending"),
    totalQuantity: int("totalQuantity").notNull(),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    schoolIdFk: foreignKey({
      columns: [table.schoolId],
      foreignColumns: [schools.id],
    }),
    masterIdFk: foreignKey({
      columns: [table.masterId],
      foreignColumns: [users.id],
    }),
  })
);

export type Order = typeof orders.$inferSelect;
export type InsertOrder = typeof orders.$inferInsert;
