import {
  mysqlTable,
  serial,
  varchar,
  datetime,
  boolean,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const expenses = mysqlTable("expenses", {
  id: serial("id").primaryKey(),
  date: datetime("date", { mode: "date" }).notNull(),
  expense: varchar("expense", { length: 255 }).notNull(),
  title: varchar("title", { length: 255 }),
  price: varchar("price", { length: 255 }).notNull(),
  isDeleted: boolean("isDeleted").default(false).notNull(),
  createdAt: datetime("createdAt", { mode: "date" }).default(
    sql`CURRENT_TIMESTAMP`
  ),
  updatedAt: datetime("updatedAt", { mode: "date" }).default(
    sql`CURRENT_TIMESTAMP`
  ),
});
