import {
  mysqlTable,
  int,
  varchar,
  decimal,
  boolean,
  datetime,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const employees = mysqlTable("employees", {
  id: int("id").primaryKey().autoincrement(),
  employeeName: varchar("employeeName", { length: 255 }).notNull(),
  email: varchar("email", { length: 255 }).notNull().unique(),
  address: varchar("address", { length: 255 }),
  phoneNumber: varchar("phoneNumber", { length: 15 }),
  skills: varchar("skills", { length: 500 }),
  paymentType: mysqlEnum("paymentType", ["Daily", "Monthly"]).default("Daily"),
  price: decimal("price", { precision: 10, scale: 2 }).default("0.00"),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type Employee = typeof employees.$inferSelect;
export type InsertEmployee = typeof employees.$inferInsert;
