import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const customers = mysqlTable("customers", {
  id: int("id").primaryKey().autoincrement(),
  name: varchar("name", { length: 255 }).notNull(),
  emailAddress: varchar("emailAddress", { length: 255 }).notNull().unique(),
  phoneNumber: varchar("phoneNumber", { length: 15 }),
  address: varchar("address", { length: 255 }),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type Customer = typeof customers.$inferSelect;
export type InsertCustomer = typeof customers.$inferInsert;
