import {
  mysqlTable,
  int,
  varchar,
  boolean,
  datetime,
  foreignKey,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";
import { schools } from "./school";

export const classes = mysqlTable(
  "classes",
  {
    id: int("id").primaryKey().autoincrement(),
    schoolId: int("schoolId").notNull(),
    name: varchar("name", { length: 255 }).notNull(),
    isDeleted: boolean("isDeleted").default(false),
    createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
    updatedAt: datetime("updatedAt").default(
      sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
    ),
  },
  (table) => ({
    schoolIdFk: foreignKey({
      columns: [table.schoolId],
      foreignColumns: [schools.id],
    }),
  })
);

export type Class = typeof classes.$inferSelect;
export type InsertClass = typeof classes.$inferInsert;
