import {
  mysqlTable,
  int,
  varchar,
  datetime,
  boolean,
  mysqlEnum,
} from "drizzle-orm/mysql-core";
import { sql } from "drizzle-orm";

export const attendance = mysqlTable("attendance", {
  id: int("id").primaryKey().autoincrement(),
  employeeId: int("employeeId").notNull(),
  employeeName: varchar("employeeName", { length: 255 }).notNull(),
  status: mysqlEnum("status", ["Present", "Absent", "Leave"]).default(
    "Present"
  ),
  attendanceDate: datetime("attendanceDate").default(sql`CURRENT_TIMESTAMP`),
  isDeleted: boolean("isDeleted").default(false),
  createdAt: datetime("createdAt").default(sql`CURRENT_TIMESTAMP`),
  updatedAt: datetime("updatedAt").default(
    sql`CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP`
  ),
});

export type Attendance = typeof attendance.$inferSelect;
export type InsertAttendance = typeof attendance.$inferInsert;
