import express from "express";
import {
  registerUser,
  loginUser,
  createUser,
  getAllUsers,
  getUserById,
  updateUser,
  deleteUser,
} from "../controllers/user";
const router = express.Router();

// Authentication routes
router.post("/register", registerUser);
router.post("/login", loginUser);

// CRUD routes
router.post("/", createUser); // Create user
router.get("/", getAllUsers); // Get all users
router.get("/:id", getUserById); // Get user by ID
router.put("/:id", updateUser); // Update user
router.delete("/:id", deleteUser); // Delete user

export default router;
