import { Router } from "express";
import {
  createShopPurchase,
  getAllShopPurchases,
  getShopPurchaseById,
  updateShopPurchase,
  deleteShopPurchase,
  getShopPurchasesByShop,
} from "../controllers/shop_purchase";

const router = Router();

router.post("/", createShopPurchase);
router.get("/", getAllShopPurchases);
router.get("/shop/:shopId", getShopPurchasesByShop); // Get purchases for specific shop
router.get("/:id", getShopPurchaseById);
router.put("/:id", updateShopPurchase);
router.delete("/:id", deleteShopPurchase);

export default router;
