import {
  createShopProduct,
  getAllShopProducts,
  updateShopProduct,
  deleteShopProduct,
  getShopProductsByShop,
} from "../controllers/shop_product";
import { Router } from "express";

const router = Router();

router.post("/", createShopProduct);
router.get("/", getAllShopProducts);
router.get("/shop/:shopId", getShopProductsByShop); // Get products for specific shop
router.put("/:id", updateShopProduct);
router.delete("/:id", deleteShopProduct);

export default router;
