import {
  createShop,
  getAllShops,
  updateShop,
  deleteShop,
  getShopkeepers,
  getMyShops,
} from "../controllers/shop";
import { Router } from "express";

const router = Router();

router.post("/", createShop);
router.get("/", getAllShops);
router.get("/shopkeepers", getShopkeepers); // Get all shopkeepers for admin
router.get("/my-shops", getMyShops); // Get shops assigned to current shopkeeper
router.put("/:id", updateShop);
router.delete("/:id", deleteShop);

export default router;
