import {
  createOrder,
  deleteOrder,
  getAllOrder,
  updateOrder,
  getMyOrders,
  getMasters,
  updateOrderStatus,
} from "../controllers/order";
import { Router } from "express";
import { authenticateToken } from "../middlewears/auth";

const router = Router();

// Apply authentication middleware to all routes
router.use(authenticateToken);

router.post("/", createOrder);
router.get("/", getAllOrder);
router.get("/my-orders", getMyOrders); // Get orders assigned to current Master
router.get("/masters", getMasters); // Get all Masters for order assignment
router.put("/:id", updateOrder);
router.put("/:id/status", updateOrderStatus); // Update order status specifically
router.delete("/:id", deleteOrder);

export default router;
