import { SessionModel } from "./session";
import { StudentModel } from "./student";
import { ClassModel } from "./class";

// Define associations here to avoid circular imports
SessionModel.belongsTo(ClassModel, { foreignKey: "classId", as: "class" });
StudentModel.belongsTo(SessionModel, {
  foreignKey: "sessionId",
  as: "session",
});
SessionModel.hasMany(StudentModel, { foreignKey: "sessionId", as: "students" });
