import { DataTypes, Model, Optional } from "sequelize";
import Joi from "joi";
import sequelize from "../middlewears/sequelize";

export interface IAddon {
  id: number;
  name: string;
  price: string;
  isDeleted: boolean;
  createdAt?: Date;
  updatedAt?: Date;
}

interface IAddonCreationAttributes
  extends Optional<IAddon, "id" | "createdAt" | "updatedAt" | "isDeleted"> {}

class AddonModel extends Model<IAddon, IAddonCreationAttributes> implements IAddon {
  public id!: number;
  public name!: string;
  public price!: string;
  public isDeleted!: boolean;
  public readonly createdAt!: Date;
  public readonly updatedAt!: Date;
}

AddonModel.init(
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    name: { type: DataTypes.STRING, allowNull: false },
    price: { type: DataTypes.STRING, allowNull: false },
    isDeleted: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    tableName: "addons",
  }
);

const addonValidationSchema = Joi.object({
  name: Joi.string().min(1).max(255).required(),
  price: Joi.string().min(1).max(255).required(),
  isDeleted: Joi.boolean().optional(),
});

export { AddonModel, addonValidationSchema };