import "dotenv/config";
import { migrate } from "drizzle-orm/mysql2/migrator";
import { initializeDatabase } from "./db";

async function runMigrations() {
  try {
    console.log("Running migrations...");
    const db = await initializeDatabase();
    await migrate(db, { migrationsFolder: "./drizzle" });
    console.log("Migrations completed successfully!");
    process.exit(0);
  } catch (error) {
    console.error("Migration failed:", error);
    process.exit(1);
  }
}

runMigrations();
