import express, { Request, Response, NextFunction } from "express";
import helmet from "helmet";
import cors from "cors";
import multer from "multer";
import userRoutes from "./routes/user";
import sizeDefinationRoutes from "./routes/size_defination";
import schoolRoutes from "./routes/school";
import classRoutes from "./routes/class";
import sessionRoutes from "./routes/session";
import studentRoutes from "./routes/student";
import orderRoutes from "./routes/order";
import orderDetailsRoutes from "./routes/order_details";
import customerRoutes from "./routes/customer";
import employeeRoutes from "./routes/employee";
import productRoutes from "./routes/product";
import purchaseRoutes from "./routes/purchase";
import shopRoutes from "./routes/shop";
import shopProductRoutes from "./routes/shop_product";
import userManagementRoutes from "./routes/user_management";
import attendanceRoutes from "./routes/attendance";
import expenseRoutes from "./routes/expense";
import addonRoutes from "./routes/addon";
import "./models/associations";
import shopPurchase from "./routes/shop_purchase";

const app = express();
const upload = multer();

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(helmet());
app.use(
  cors({
    origin: "*",
    methods: ["GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"],
    allowedHeaders: ["Content-Type", "Authorization"],
  })
);

/// USERS
app.use("/api/users", upload.any(), userRoutes);

/// SIZE DEFINITIONS
app.use("/api/sizeDefinitions", upload.any(), sizeDefinationRoutes);

/// SCHOOLS
app.use("/api/schools", schoolRoutes);

/// CLASSES
app.use("/api/classes", upload.any(), classRoutes);

/// SESSIONS
app.use("/api/sessions", upload.any(), sessionRoutes);

/// STUDENTS
app.use("/api/students", upload.any(), studentRoutes);

/// ORDERS
app.use("/api/orders", upload.any(), orderRoutes);

/// ORDER DETAILS
app.use("/api/orderDetails", upload.any(), orderDetailsRoutes);

/// CUSTOMERS
app.use("/api/customers", upload.any(), customerRoutes);

/// EMPLOYEES
app.use("/api/employees", upload.any(), employeeRoutes);

/// PRODUCTS
app.use("/api/products", upload.any(), productRoutes);

/// PURCHASES
app.use("/api/purchases", upload.any(), purchaseRoutes);

/// SHOPS
app.use("/api/shops", upload.any(), shopRoutes);

/// SHOP PRODUCTS
app.use("/api/shopProducts", upload.any(), shopProductRoutes);

/// SHOP PURCHASE
app.use("/api/shopPurchases", upload.any(), shopPurchase);

/// USER MANAGEMENT
app.use("/api/userManagement", upload.any(), userManagementRoutes);

/// ATTENDANCE
app.use("/api/attendance", upload.any(), attendanceRoutes);

/// EXPENSES
app.use("/api/expenses", upload.any(), expenseRoutes);

/// ADDONS
app.use("/api/addons", upload.any(), addonRoutes);

// Serve uploaded files statically
app.use("/uploads", express.static("uploads"));

/// 404 Handler
app.use((req: Request, res: Response, next: NextFunction) => {
  let error: CustomError = new Error("Not Found");
  error.status = 404;
  next(error);
});

app.use((err: CustomError, req: Request, res: Response, next: NextFunction) => {
  res.status(err.status || 500);
  res.json({
    error: {
      message: err.message,
    },
  });
});

export default app;

interface CustomError extends Error {
  status?: number;
}
