"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var errors_exports = {};
__export(errors_exports, {
  DrizzleError: () => DrizzleError,
  DrizzleQueryError: () => DrizzleQueryError,
  TransactionRollbackError: () => TransactionRollbackError
});
module.exports = __toCommonJS(errors_exports);
var import_entity = require("./entity.cjs");
class DrizzleError extends Error {
  static [import_entity.entityKind] = "DrizzleError";
  constructor({ message, cause }) {
    super(message);
    this.name = "DrizzleError";
    this.cause = cause;
  }
}
class DrizzleQueryError extends Error {
  constructor(query, params, cause) {
    super(`Failed query: ${query}
params: ${params}`);
    this.query = query;
    this.params = params;
    this.cause = cause;
    Error.captureStackTrace(this, DrizzleQueryError);
    if (cause) this.cause = cause;
  }
}
class TransactionRollbackError extends DrizzleError {
  static [import_entity.entityKind] = "TransactionRollbackError";
  constructor() {
    super({ message: "Rollback" });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DrizzleError,
  DrizzleQueryError,
  TransactionRollbackError
});
//# sourceMappingURL=errors.cjs.map