require("dotenv/config");
const mysql = require("mysql2/promise");
const fs = require("fs");

(async () => {
  try {
    const conn = await mysql.createConnection({
      host: process.env.DB_HOST || "localhost",
      user: process.env.DB_USER || "root",
      password: process.env.DB_PASSWORD || undefined,
      database: process.env.DB_NAME || "tuc",
    });

    console.log("\n🔧 Adding addons column to order_details table...\n");

    try {
      await conn.execute("ALTER TABLE `order_details` ADD COLUMN `addons` json");
      console.log("✅ Successfully added addons column to order_details table");
    } catch (err) {
      if (err.code === "ER_DUP_FIELDNAME") {
        console.log("⚠️  Addons column already exists in order_details table");
      } else {
        console.error(`❌ Error adding addons column: ${err.message}`);
      }
    }

    // Verify the column was added
    const [columns] = await conn.execute("DESCRIBE `order_details`");
    const hasAddonsColumn = columns.some(col => col.Field === 'addons');
    
    if (hasAddonsColumn) {
      console.log("✅ Addons column confirmed in order_details table!");
    } else {
      console.log("❌ Addons column not found in order_details table!");
    }

    await conn.end();
  } catch (error) {
    console.error("❌ Connection Error:", error.message);
    process.exit(1);
  }
})();