import { defineConfig } from "drizzle-kit";
import "dotenv/config";

const dbPassword = process.env.DB_PASSWORD;

export default defineConfig({
  schema: "./src/schema/*",
  out: "./drizzle",
  dialect: "mysql",
  dbCredentials: {
    host: process.env.DB_HOST || "localhost",
    user: process.env.DB_USER || "root",
    password: dbPassword || undefined,
    database: process.env.DB_NAME || "tuc",
  },
  migrations: {
    table: "__drizzle_migrations__",
    schema: "public",
  },
});
