"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const school_1 = require("../controllers/school");
const express_1 = require("express");
const file_upload_1 = require("../functions/file_upload");
const router = (0, express_1.Router)();
router.post("/", file_upload_1.upload.single("logo"), school_1.createSchool);
router.get("/", school_1.getAllSchools);
router.put("/:id", file_upload_1.upload.single("logo"), school_1.updateSchool);
router.delete("/:id", school_1.deleteSchool);
exports.default = router;
