"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.userManagementValidationSchema = exports.UserManagementModel = exports.UserRole = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
var UserRole;
(function (UserRole) {
    UserRole["Admin"] = "Admin";
    UserRole["Shopkeeper"] = "Shopkeeper";
    UserRole["Tailor"] = "Tailor";
    UserRole["Master"] = "Master";
})(UserRole || (exports.UserRole = UserRole = {}));
class UserManagementModel extends sequelize_1.Model {
}
exports.UserManagementModel = UserManagementModel;
UserManagementModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    phoneNumber: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    role: {
        type: sequelize_1.DataTypes.ENUM(...Object.values(UserRole)),
        allowNull: false,
        defaultValue: UserRole.Admin,
    },
    hasShopAccess: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    hasUserAccess: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    hasOrderAccess: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    hasSizeDefinitionAccess: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "user_managements",
});
const userManagementValidationSchema = joi_1.default.object({
    name: joi_1.default.string().min(1).max(100).required(),
    phoneNumber: joi_1.default.string().min(7).max(15).required(),
    role: joi_1.default.string()
        .valid(...Object.values(UserRole))
        .optional(),
    hasShopAccess: joi_1.default.boolean().optional(),
    hasUserAccess: joi_1.default.boolean().optional(),
    hasOrderAccess: joi_1.default.boolean().optional(),
    hasSizeDefinitionAccess: joi_1.default.boolean().optional(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.userManagementValidationSchema = userManagementValidationSchema;
