"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateAuthToken = exports.userSchema = exports.UserModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
class UserModel extends sequelize_1.Model {
}
exports.UserModel = UserModel;
// Initialize the model
UserModel.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
    },
    name: {
        type: sequelize_1.DataTypes.STRING(100),
        allowNull: false,
    },
    email: {
        type: sequelize_1.DataTypes.STRING(100),
        allowNull: false,
        unique: true,
        validate: {
            isEmail: true,
        },
    },
    password: {
        type: sequelize_1.DataTypes.STRING(255),
        allowNull: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    tableName: "users",
    sequelize: sequelize_2.default,
});
// Joi validation schema for incoming requests
const userSchema = joi_1.default.object({
    name: joi_1.default.string().min(3).max(30).required(),
    email: joi_1.default.string().email().required(),
    password: joi_1.default.string().min(6).required(),
});
exports.userSchema = userSchema;
// Generate JWT Token
const generateAuthToken = (user) => {
    const payload = {
        id: user.id,
        email: user.email,
        createdAt: Date.now(),
    };
    const secret = "TheUniformCenter!@#$%54321";
    return jsonwebtoken_1.default.sign(payload, secret, { algorithm: "HS256" });
};
exports.generateAuthToken = generateAuthToken;
