"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateStudentValidationSchema = exports.studentValidationSchema = exports.StudentModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class StudentModel extends sequelize_1.Model {
}
exports.StudentModel = StudentModel;
StudentModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    sessionId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: { model: "sessions", key: "id" },
    },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    gender: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    sizeNumber: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    upperWear: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: false,
    },
    lowerWear: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: false,
    },
    headcover: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: true,
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "students",
});
const studentValidationSchema = joi_1.default.object({
    sessionId: joi_1.default.number().integer().required(),
    name: joi_1.default.string().min(1).max(255).required(),
    gender: joi_1.default.string().valid("male", "female").required(),
    sizeNumber: joi_1.default.string().min(1).max(50).required(),
    upperWear: joi_1.default.object({
        collar: joi_1.default.string().required(),
        cuff: joi_1.default.string().required(),
        tera: joi_1.default.string().required(),
        bazo: joi_1.default.string().required(),
        armhole: joi_1.default.string().required(),
        chest: joi_1.default.string().required(),
        bokramUsed: joi_1.default.string().optional(),
        collarUsed: joi_1.default.string().optional(),
        buttonUsed: joi_1.default.string().optional(),
        fabricUsed: joi_1.default.string().required(),
        upperWearPrice: joi_1.default.string().required(),
    }).required(),
    lowerWear: joi_1.default.object({
        losign: joi_1.default.string().required(),
        hip: joi_1.default.string().required(),
        waist: joi_1.default.string().required(),
        bottom: joi_1.default.string().required(),
        zipUsed: joi_1.default.string().optional(),
        buttonUsed: joi_1.default.string().optional(),
        hookUsed: joi_1.default.string().optional(),
        fabricUsed: joi_1.default.string().required(),
        lowerWearPrice: joi_1.default.string().required(),
    }).required(),
    headcover: joi_1.default.object({
        type: joi_1.default.string().required(),
        length: joi_1.default.string().required(),
        fabricUsed: joi_1.default.string().required(),
        headCoverPrice: joi_1.default.string().required(),
    }).when("gender", {
        is: "female",
        then: joi_1.default.optional(),
        otherwise: joi_1.default.forbidden(),
    }),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.studentValidationSchema = studentValidationSchema;
const updateStudentValidationSchema = joi_1.default.object({
    sessionId: joi_1.default.number().integer().optional(),
    name: joi_1.default.string().min(1).max(255).optional(),
    gender: joi_1.default.string().valid("male", "female").optional(),
    sizeNumber: joi_1.default.string().min(1).max(50).optional(),
    upperWear: joi_1.default.object({
        collar: joi_1.default.string().optional(),
        cuff: joi_1.default.string().optional(),
        tera: joi_1.default.string().optional(),
        bazo: joi_1.default.string().optional(),
        armhole: joi_1.default.string().optional(),
        chest: joi_1.default.string().optional(),
        bokramUsed: joi_1.default.string().optional(),
        collarUsed: joi_1.default.string().optional(),
        buttonUsed: joi_1.default.string().optional(),
        fabricUsed: joi_1.default.string().optional(),
        upperWearPrice: joi_1.default.string().optional(),
    }).optional(),
    lowerWear: joi_1.default.object({
        losign: joi_1.default.string().optional(),
        hip: joi_1.default.string().optional(),
        waist: joi_1.default.string().optional(),
        bottom: joi_1.default.string().optional(),
        zipUsed: joi_1.default.string().optional(),
        buttonUsed: joi_1.default.string().optional(),
        hookUsed: joi_1.default.string().optional(),
        fabricUsed: joi_1.default.string().optional(),
        lowerWearPrice: joi_1.default.string().optional(),
    }).optional(),
    headcover: joi_1.default.object({
        type: joi_1.default.string().optional(),
        length: joi_1.default.string().optional(),
        fabricUsed: joi_1.default.string().optional(),
        headCoverPrice: joi_1.default.string().optional(),
    }).when("gender", {
        is: "female",
        then: joi_1.default.optional(),
        otherwise: joi_1.default.forbidden(),
    }),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.updateStudentValidationSchema = updateStudentValidationSchema;
