"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sizeDefinationSchema = exports.SizeDefinationModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize")); // Assuming this path is correct
// Sequelize Model Class
class SizeDefinationModel extends sequelize_1.Model {
}
exports.SizeDefinationModel = SizeDefinationModel;
// Initialize the model
SizeDefinationModel.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
    },
    sizeNumber: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    gender: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    upperWear: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: false,
    },
    lowerWear: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: false,
    },
    headCover: {
        type: sequelize_1.DataTypes.JSON, // Storing object as JSON in the database
        allowNull: true, // This field is optional
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    tableName: "size_defination",
    sequelize: sequelize_2.default,
});
// Joi validation schema for incoming API requests
const sizeDefinationSchema = joi_1.default.object({
    sizeNumber: joi_1.default.string().required(),
    gender: joi_1.default.string().required(),
    upperWear: joi_1.default.object({
        collar: joi_1.default.string().required(),
        cuff: joi_1.default.string().required(),
        tera: joi_1.default.string().required(),
        bazo: joi_1.default.string().required(),
        armhole: joi_1.default.string().required(),
        chest: joi_1.default.string().required(),
        bokramUsed: joi_1.default.string().optional(), // Changed to optional
        collarUsed: joi_1.default.string().optional(), // Changed to optional
        buttonUsed: joi_1.default.string().optional(), // Changed to optional
        fabricUsed: joi_1.default.string().required(),
        upperWearPrice: joi_1.default.string().required(),
    }).required(),
    lowerWear: joi_1.default.object({
        losign: joi_1.default.string().required(),
        hip: joi_1.default.string().required(),
        waist: joi_1.default.string().required(),
        bottom: joi_1.default.string().required(),
        zipUsed: joi_1.default.string().optional(), // Changed to optional
        buttonUsed: joi_1.default.string().optional(), // Changed to optional
        hookUsed: joi_1.default.string().optional(), // Changed to optional
        fabricUsed: joi_1.default.string().required(),
        lowerWearPrice: joi_1.default.string().required(),
    }).required(),
    headCover: joi_1.default.object({
        type: joi_1.default.string().required(),
        length: joi_1.default.string().required(),
        fabricUsed: joi_1.default.string().required(),
        headCoverPrice: joi_1.default.string().required(),
    }).optional(),
});
exports.sizeDefinationSchema = sizeDefinationSchema;
