"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.shopProductValidationSchema = exports.ShopProductModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class ShopProductModel extends sequelize_1.Model {
}
exports.ShopProductModel = ShopProductModel;
ShopProductModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    shopId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: { model: "shops", key: "id" },
    },
    shopName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    shopProductName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    shopProductUnit: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "shop_products",
});
const shopProductValidationSchema = joi_1.default.object({
    shopId: joi_1.default.number().integer().required(),
    shopName: joi_1.default.string().min(1).max(100).required(),
    shopProductName: joi_1.default.string().min(1).max(100).required(),
    shopProductUnit: joi_1.default.string().min(1).max(50).required(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.shopProductValidationSchema = shopProductValidationSchema;
