"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.shopValidationSchema = exports.ShopModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class ShopModel extends sequelize_1.Model {
}
exports.ShopModel = ShopModel;
ShopModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    location: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    number: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "shops",
});
const shopValidationSchema = joi_1.default.object({
    name: joi_1.default.string().min(1).max(100).required(),
    location: joi_1.default.string().min(1).max(255).required(),
    number: joi_1.default.string().min(7).max(15).required(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.shopValidationSchema = shopValidationSchema;
