"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateSessionValidationSchema = exports.sessionValidationSchema = exports.SessionModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class SessionModel extends sequelize_1.Model {
}
exports.SessionModel = SessionModel;
SessionModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    classId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: { model: "classes", key: "id" },
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "sessions",
});
const sessionValidationSchema = joi_1.default.object({
    name: joi_1.default.string().min(1).max(255).required(),
    classId: joi_1.default.number().integer().required(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.sessionValidationSchema = sessionValidationSchema;
const updateSessionValidationSchema = joi_1.default.object({
    name: joi_1.default.string().min(1).max(255).optional(),
    classId: joi_1.default.number().integer().optional(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.updateSessionValidationSchema = updateSessionValidationSchema;
