"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.schoolValidationSchema = exports.SchoolModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class SchoolModel extends sequelize_1.Model {
}
exports.SchoolModel = SchoolModel;
SchoolModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    logo: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    address: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    principalName: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    principalContact: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    receptionistName: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    receptionistContact: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "schools",
});
const schoolValidationSchema = joi_1.default.object({
    logo: joi_1.default.string().uri().required(),
    name: joi_1.default.string().min(3).max(100).required(),
    address: joi_1.default.string().min(10).max(255).required(),
    principalName: joi_1.default.string().min(3).max(100).optional(),
    principalContact: joi_1.default.string().min(7).max(15).optional(),
    receptionistName: joi_1.default.string().min(3).max(100).optional(),
    receptionistContact: joi_1.default.string().min(7).max(15).optional(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.schoolValidationSchema = schoolValidationSchema;
