"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.purchaseValidationSchema = exports.PurchaseModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class PurchaseModel extends sequelize_1.Model {
}
exports.PurchaseModel = PurchaseModel;
PurchaseModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    productId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: { model: "products", key: "id" },
    },
    productName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    productUnit: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    quantity: { type: sequelize_1.DataTypes.INTEGER, allowNull: false },
    totalPrice: {
        type: sequelize_1.DataTypes.DECIMAL(10, 2),
        allowNull: false,
    },
    perUnitPrice: {
        type: sequelize_1.DataTypes.DECIMAL(10, 2),
        allowNull: false,
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "purchases",
});
const purchaseValidationSchema = joi_1.default.object({
    productId: joi_1.default.number().integer().required(),
    productName: joi_1.default.string().min(1).max(100).required(),
    productUnit: joi_1.default.string().min(1).max(50).required(),
    quantity: joi_1.default.number().integer().min(1).required(),
    totalPrice: joi_1.default.number().min(0).required(),
    perUnitPrice: joi_1.default.number().min(0).required(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.purchaseValidationSchema = purchaseValidationSchema;
