"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.productValidationSchema = exports.ProductModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class ProductModel extends sequelize_1.Model {
}
exports.ProductModel = ProductModel;
ProductModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    productName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    productUnit: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "products",
});
const productValidationSchema = joi_1.default.object({
    productName: joi_1.default.string().min(1).max(100).required(),
    productUnit: joi_1.default.string().min(1).max(50).required(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.productValidationSchema = productValidationSchema;
