"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderDetailsValidationSchema = exports.OrderDetails = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
const order_1 = require("./order");
class OrderDetails extends sequelize_1.Model {
}
exports.OrderDetails = OrderDetails;
OrderDetails.init({
    id: { type: sequelize_1.DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
    orderId: {
        type: sequelize_1.DataTypes.INTEGER,
        references: { model: "orders", key: "id" },
        allowNull: false,
    },
    studentName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    sizeNumber: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    gender: {
        type: sequelize_1.DataTypes.ENUM("male", "female"),
        allowNull: false,
    },
    orderOf: {
        type: sequelize_1.DataTypes.ENUM("upperWear", "lowerWear", "both"),
        allowNull: false,
    },
    upperWear: { type: sequelize_1.DataTypes.JSON, allowNull: true },
    lowerWear: { type: sequelize_1.DataTypes.JSON, allowNull: true },
    headCover: { type: sequelize_1.DataTypes.JSON, allowNull: true },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "order_details",
});
// Associations
OrderDetails.belongsTo(order_1.Order, { foreignKey: "orderId", as: "order" });
const OrderDetailsValidationSchema = joi_1.default.object({
    orderId: joi_1.default.number().integer().min(1).required(),
    studentName: joi_1.default.string().min(1).max(255).required(),
    sizeNumber: joi_1.default.string().min(1).max(255).required(),
    gender: joi_1.default.string().valid("male", "female").required(),
    orderOf: joi_1.default.string().valid("upperWear", "lowerWear", "both").required(),
    upperWear: joi_1.default.when("orderOf", {
        is: joi_1.default.valid("upperWear", "both"),
        then: joi_1.default.object({
            collar: joi_1.default.string().required(),
            cuff: joi_1.default.string().required(),
            tera: joi_1.default.string().required(),
            bazo: joi_1.default.string().required(),
            armhole: joi_1.default.string().required(),
            chest: joi_1.default.string().required(),
            bokramUsed: joi_1.default.string().optional(),
            collarUsed: joi_1.default.string().optional(),
            buttonUsed: joi_1.default.string().optional(),
            fabricUsed: joi_1.default.string().required(),
            upperWearPrice: joi_1.default.string().required(),
        }).required(),
        otherwise: joi_1.default.forbidden(),
    }),
    lowerWear: joi_1.default.when("orderOf", {
        is: joi_1.default.valid("lowerWear", "both"),
        then: joi_1.default.object({
            losign: joi_1.default.string().required(),
            hip: joi_1.default.string().required(),
            waist: joi_1.default.string().required(),
            bottom: joi_1.default.string().required(),
            zipUsed: joi_1.default.string().optional(),
            buttonUsed: joi_1.default.string().optional(),
            hookUsed: joi_1.default.string().optional(),
            fabricUsed: joi_1.default.string().required(),
            lowerWearPrice: joi_1.default.string().required(),
        }).required(),
        otherwise: joi_1.default.forbidden(),
    }),
    headCover: joi_1.default.object({
        type: joi_1.default.string().required(),
        length: joi_1.default.string().required(),
        fabricUsed: joi_1.default.string().required(),
        headCoverPrice: joi_1.default.string().required(),
    }).optional(),
});
exports.OrderDetailsValidationSchema = OrderDetailsValidationSchema;
