"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderValidationSchema = exports.Order = exports.OrderType = void 0;
const sequelize_1 = require("sequelize");
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
const joi_1 = __importDefault(require("joi"));
var OrderType;
(function (OrderType) {
    OrderType["BULK"] = "Bulk Order";
    OrderType["CUSTOM"] = "Custom Order";
})(OrderType || (exports.OrderType = OrderType = {}));
class Order extends sequelize_1.Model {
}
exports.Order = Order;
Order.init({
    id: { type: sequelize_1.DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
    schoolId: {
        type: sequelize_1.DataTypes.INTEGER,
        references: { model: "schools", key: "id" },
        allowNull: false,
    },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    address: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    phoneNumber: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    totalPrice: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    type: {
        type: sequelize_1.DataTypes.ENUM(...Object.values(OrderType)),
        allowNull: false,
    },
    totalQuantity: { type: sequelize_1.DataTypes.INTEGER, allowNull: false },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        defaultValue: false,
        allowNull: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "orders",
});
const OrderValidationSchema = joi_1.default.object({
    name: joi_1.default.string().min(1).max(255).required(),
    address: joi_1.default.string().min(1).max(255).required(),
    phoneNumber: joi_1.default.string().min(1).max(255).required(),
    totalPrice: joi_1.default.string().min(1).max(255).required(),
    totalQuantity: joi_1.default.number().min(1).required(),
    type: joi_1.default.string().valid(OrderType.BULK, OrderType.CUSTOM).required(),
    schoolId: joi_1.default.number().min(1).required(),
    isDeleted: joi_1.default.boolean().default(false).optional(),
});
exports.OrderValidationSchema = OrderValidationSchema;
