"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.employeeValidationSchema = exports.EmployeeModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class EmployeeModel extends sequelize_1.Model {
}
exports.EmployeeModel = EmployeeModel;
EmployeeModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    employeeName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    email: { type: sequelize_1.DataTypes.STRING, allowNull: false, unique: true },
    address: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    phoneNumber: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    skills: { type: sequelize_1.DataTypes.STRING, allowNull: true },
    paymentType: {
        type: sequelize_1.DataTypes.ENUM("Daily", "Monthly"),
        allowNull: false,
        defaultValue: "Daily",
    },
    price: {
        type: sequelize_1.DataTypes.DECIMAL(10, 2),
        allowNull: false,
        defaultValue: 0.0,
    },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "employees",
});
const employeeValidationSchema = joi_1.default.object({
    employeeName: joi_1.default.string().min(1).max(100).required(),
    email: joi_1.default.string().email().required(),
    address: joi_1.default.string().min(1).max(255).optional(),
    phoneNumber: joi_1.default.string().min(7).max(15).optional(),
    skills: joi_1.default.string().min(1).max(500).optional(),
    paymentType: joi_1.default.string().valid("Daily", "Monthly").optional(),
    price: joi_1.default.number().min(0).optional(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.employeeValidationSchema = employeeValidationSchema;
