"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.classValidationSchema = exports.ClassModel = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
class ClassModel extends sequelize_1.Model {
}
exports.ClassModel = ClassModel;
ClassModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    schoolId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: { model: "schools", key: "id" },
    },
    name: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, { sequelize: sequelize_2.default, tableName: "classes" });
const classValidationSchema = joi_1.default.object({
    schoolId: joi_1.default.number().integer().required(),
    name: joi_1.default.string().min(1).max(255).required(),
});
exports.classValidationSchema = classValidationSchema;
