"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.attendanceValidationSchema = exports.AttendanceModel = exports.AttendanceStatus = void 0;
const sequelize_1 = require("sequelize");
const joi_1 = __importDefault(require("joi"));
const sequelize_2 = __importDefault(require("../middlewears/sequelize"));
var AttendanceStatus;
(function (AttendanceStatus) {
    AttendanceStatus["Present"] = "Present";
    AttendanceStatus["Absent"] = "Absent";
    AttendanceStatus["Leave"] = "Leave";
})(AttendanceStatus || (exports.AttendanceStatus = AttendanceStatus = {}));
class AttendanceModel extends sequelize_1.Model {
}
exports.AttendanceModel = AttendanceModel;
AttendanceModel.init({
    id: { type: sequelize_1.DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    employeeId: { type: sequelize_1.DataTypes.INTEGER, allowNull: false },
    employeeName: { type: sequelize_1.DataTypes.STRING, allowNull: false },
    status: {
        type: sequelize_1.DataTypes.ENUM(...Object.values(AttendanceStatus)),
        allowNull: false,
        defaultValue: AttendanceStatus.Present,
    },
    attendanceDate: { type: sequelize_1.DataTypes.DATE, allowNull: true },
    isDeleted: {
        type: sequelize_1.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    createdAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updatedAt: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: sequelize_2.default,
    tableName: "attendances",
});
const attendanceValidationSchema = joi_1.default.object({
    employeeId: joi_1.default.number().integer().required(),
    employeeName: joi_1.default.string().min(1).max(100).required(),
    status: joi_1.default.string()
        .valid(...Object.values(AttendanceStatus))
        .optional(),
    attendanceDate: joi_1.default.date().optional(),
    isDeleted: joi_1.default.boolean().optional(),
});
exports.attendanceValidationSchema = attendanceValidationSchema;
