"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const session_1 = require("./session");
const student_1 = require("./student");
const class_1 = require("./class");
// Define associations here to avoid circular imports
session_1.SessionModel.belongsTo(class_1.ClassModel, { foreignKey: "classId", as: "class" });
student_1.StudentModel.belongsTo(session_1.SessionModel, {
    foreignKey: "sessionId",
    as: "session",
});
session_1.SessionModel.hasMany(student_1.StudentModel, { foreignKey: "sessionId", as: "students" });
