"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteUserManagement = exports.updateUserManagement = exports.getAllUserManagements = exports.createUserManagement = void 0;
const user_management_1 = require("../models/user_management");
/// Create new user management
const createUserManagement = async (req, res) => {
    const { error } = user_management_1.userManagementValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const newUserManagement = await user_management_1.UserManagementModel.create(req.body);
        return res
            .status(200)
            .json({
            message: "User created successfully.",
            id: newUserManagement.id,
        });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.createUserManagement = createUserManagement;
/// Get all user managements
const getAllUserManagements = async (req, res) => {
    try {
        const userManagements = await user_management_1.UserManagementModel.findAll({
            where: { isDeleted: false },
        });
        return res.status(200).json(userManagements);
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getAllUserManagements = getAllUserManagements;
/// Update existing user management
const updateUserManagement = async (req, res) => {
    try {
        // Find the user management by ID
        const userManagement = await user_management_1.UserManagementModel.findByPk(req.params.id);
        if (!userManagement)
            return res.status(404).json({ error: "User not found." });
        // Validate the request body
        const { error } = user_management_1.userManagementValidationSchema.validate(req.body);
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        // Update the user management details
        await userManagement.update(req.body);
        // Send success response
        return res
            .status(200)
            .json({ message: "User updated successfully.", id: userManagement.id });
    }
    catch (ex) {
        console.error(`Error updating user: ${ex}`);
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.updateUserManagement = updateUserManagement;
/// Delete a user management
const deleteUserManagement = async (req, res) => {
    try {
        // Find the user management by ID
        const userManagement = await user_management_1.UserManagementModel.findByPk(req.params.id);
        if (!userManagement)
            return res.status(404).json({ error: "User not found." });
        // Soft delete the user management
        await userManagement.update({ isDeleted: true });
        // Send success response
        return res.status(200).json({ message: "User deleted successfully." });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteUserManagement = deleteUserManagement;
