"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteStudent = exports.updateStudent = exports.getAllStudents = exports.createStudent = void 0;
const student_1 = require("../models/student");
/// Create new student
const createStudent = async (req, res) => {
    const { error } = student_1.studentValidationSchema.validate(req.body);
    if (error) {
        return res.status(400).json({ error: error.details[0].message });
    }
    try {
        const student = await student_1.StudentModel.create(req.body);
        res
            .status(200)
            .json({ message: "Student created successfully", id: student.id });
    }
    catch (err) {
        console.log(`Erro Occired: ${err}`);
        return res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.createStudent = createStudent;
/// Get all students
const getAllStudents = async (req, res) => {
    try {
        const students = await student_1.StudentModel.findAll({
            where: { isDeleted: 0, sessionId: req.params.id },
        });
        const response = students.map((item) => {
            return Object.assign(Object.assign({}, item.toJSON()), { upperWear: JSON.parse(item.upperWear.toString()), lowerWear: JSON.parse(item.lowerWear.toString()), headcover: item.headcover !== null
                    ? JSON.parse(item.headcover.toString())
                    : null });
        });
        return res.status(200).json(response);
    }
    catch (err) {
        return res.status(500).json({ error: "Internal server error" });
    }
};
exports.getAllStudents = getAllStudents;
const updateStudent = async (req, res) => {
    try {
        const student = await student_1.StudentModel.findByPk(req.params.id);
        if (!student)
            return res.status(404).json({ error: "Student not found." });
        const { error } = student_1.updateStudentValidationSchema.validate(req.body, {
            allowUnknown: true,
        });
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        await student.update(req.body);
        res
            .status(200)
            .json({ message: "Student updated successfully.", data: student });
    }
    catch (ex) {
        console.error(ex);
        res.status(500).json({ error: "Internal server error" });
    }
};
exports.updateStudent = updateStudent;
/// Delete student
const deleteStudent = async (req, res) => {
    try {
        // Find the student by ID
        const student = await student_1.StudentModel.findByPk(req.params.id);
        if (!student)
            return res.status(404).json({ error: "Student not found." });
        // Soft delete the student
        await student.update({ isDeleted: true });
        // Send success response
        res.status(200).json({ message: "Student deleted successfully." });
    }
    catch (ex) {
        res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteStudent = deleteStudent;
